/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.unnamedanimalmod.common.entity;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import teamdraco.unnamedanimalmod.common.entity.MangroveSnakeEntity;

public class BlubberJellyEntity
extends AbstractFishEntity {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(MangroveSnakeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float squidPitch;
    public float prevSquidPitch;
    public float squidYaw;
    public float prevSquidYaw;
    public float squidRotation;
    public float prevSquidRotation;
    public float tentacleAngle;
    public float lastTentacleAngle;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float rotateSpeed;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;

    public BlubberJellyEntity(EntityType<? extends AbstractFishEntity> type, World p_i48565_2_) {
        super(type, p_i48565_2_);
        this.field_70146_Z.setSeed(this.func_145782_y());
        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (dataTag == null) {
            this.setVariant(this.field_70146_Z.nextInt(12));
        } else if (dataTag.func_150297_b("Variant", 3)) {
            this.setVariant(dataTag.func_74762_e("Variant"));
        }
        return spawnDataIn;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MoveRandomGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FleeGoal());
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0);
    }

    protected void func_204211_f(ItemStack bucket) {
        super.func_204211_f(bucket);
        CompoundNBT compoundnbt = bucket.func_196082_o();
        compoundnbt.func_74768_a("Variant", this.getVariant());
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.5f;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevSquidPitch = this.squidPitch;
        this.prevSquidYaw = this.squidYaw;
        this.prevSquidRotation = this.squidRotation;
        this.lastTentacleAngle = this.tentacleAngle;
        this.squidRotation += this.rotationVelocity;
        if ((double)this.squidRotation > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.squidRotation = (float)Math.PI * 2;
            } else {
                this.squidRotation = (float)((double)this.squidRotation - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)30);
            }
        }
        if (this.func_203005_aq()) {
            if (this.squidRotation < (float)Math.PI) {
                float f = this.squidRotation / (float)Math.PI;
                this.tentacleAngle = MathHelper.func_76126_a((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_213293_j(this.randomMotionVecX * this.randomMotionSpeed, this.randomMotionVecY * this.randomMotionSpeed, this.randomMotionVecZ * this.randomMotionSpeed);
            }
            Vector3d vector3d = this.func_213322_ci();
            float f1 = MathHelper.func_76133_a((double)BlubberJellyEntity.func_213296_b((Vector3d)vector3d));
            this.field_70761_aq += (-((float)MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c)) * 57.295776f - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.squidYaw = (float)((double)this.squidYaw + Math.PI * (double)this.rotateSpeed * 1.5);
            this.squidPitch += (-((float)MathHelper.func_181159_b((double)f1, (double)vector3d.field_72448_b)) * 57.295776f - this.squidPitch) * 0.1f;
        } else {
            this.tentacleAngle = MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)this.squidRotation)) * (float)Math.PI * 0.25f;
            if (!this.field_70170_p.field_72995_K) {
                double d0 = this.func_213322_ci().field_72448_b;
                if (this.func_70644_a(Effects.field_188424_y)) {
                    d0 = 0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1);
                } else if (!this.func_189652_ae()) {
                    d0 -= 0.08;
                }
                this.func_213293_j(0.0, d0 * (double)0.98f, 0.0);
            }
            this.squidPitch = (float)((double)this.squidPitch + (double)(-90.0f - this.squidPitch) * 0.02);
        }
    }

    public void func_213352_e(Vector3d travelVector) {
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 30) {
            this.squidRotation = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    protected ItemStack func_203707_dx() {
        return null;
    }

    protected SoundEvent func_203701_dz() {
        return SoundEvents.field_203818_az;
    }

    public void setMovementVector(float randomMotionVecXIn, float randomMotionVecYIn, float randomMotionVecZIn) {
        this.randomMotionVecX = randomMotionVecXIn;
        this.randomMotionVecY = randomMotionVecYIn;
        this.randomMotionVecZ = randomMotionVecZIn;
    }

    public boolean hasMovementVector() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    class MoveRandomGoal
    extends Goal {
        private final BlubberJellyEntity jelly;

        public MoveRandomGoal(BlubberJellyEntity p_i48823_2_) {
            this.jelly = p_i48823_2_;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            int i = this.jelly.func_70654_ax();
            if (i > 100) {
                this.jelly.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.jelly.func_70681_au().nextInt(50) == 0 || !this.jelly.field_70171_ac || !this.jelly.hasMovementVector()) {
                float f = this.jelly.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                float f1 = MathHelper.func_76134_b((float)f) * 0.2f;
                float f2 = -0.1f + this.jelly.func_70681_au().nextFloat() * 0.2f;
                float f3 = MathHelper.func_76126_a((float)f) * 0.2f;
                this.jelly.setMovementVector(f1, f2, f3);
            }
        }
    }

    class FleeGoal
    extends Goal {
        private int tickCounter;

        private FleeGoal() {
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = BlubberJellyEntity.this.func_70643_av();
            if (BlubberJellyEntity.this.func_70090_H() && livingentity != null) {
                return BlubberJellyEntity.this.func_70068_e((Entity)livingentity) < 100.0;
            }
            return false;
        }

        public void func_75249_e() {
            this.tickCounter = 0;
        }

        public void func_75246_d() {
            ++this.tickCounter;
            LivingEntity livingentity = BlubberJellyEntity.this.func_70643_av();
            if (livingentity != null) {
                Vector3d vector3d = new Vector3d(BlubberJellyEntity.this.func_226277_ct_() - livingentity.func_226277_ct_(), BlubberJellyEntity.this.func_226278_cu_() - livingentity.func_226278_cu_(), BlubberJellyEntity.this.func_226281_cx_() - livingentity.func_226281_cx_());
                BlockState blockstate = BlubberJellyEntity.this.field_70170_p.func_180495_p(new BlockPos(BlubberJellyEntity.this.func_226277_ct_() + vector3d.field_72450_a, BlubberJellyEntity.this.func_226278_cu_() + vector3d.field_72448_b, BlubberJellyEntity.this.func_226281_cx_() + vector3d.field_72449_c));
                FluidState fluidstate = BlubberJellyEntity.this.field_70170_p.func_204610_c(new BlockPos(BlubberJellyEntity.this.func_226277_ct_() + vector3d.field_72450_a, BlubberJellyEntity.this.func_226278_cu_() + vector3d.field_72448_b, BlubberJellyEntity.this.func_226281_cx_() + vector3d.field_72449_c));
                if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) || blockstate.func_196958_f()) {
                    double d0 = vector3d.func_72433_c();
                    if (d0 > 0.0) {
                        vector3d.func_72432_b();
                        float f = 3.0f;
                        if (d0 > 5.0) {
                            f = (float)((double)f - (d0 - 5.0) / 5.0);
                        }
                        if (f > 0.0f) {
                            vector3d = vector3d.func_186678_a((double)f);
                        }
                    }
                    if (blockstate.func_196958_f()) {
                        vector3d = vector3d.func_178786_a(0.0, vector3d.field_72448_b, 0.0);
                    }
                    BlubberJellyEntity.this.setMovementVector((float)vector3d.field_72450_a / 20.0f, (float)vector3d.field_72448_b / 20.0f, (float)vector3d.field_72449_c / 20.0f);
                }
                if (this.tickCounter % 10 == 5) {
                    BlubberJellyEntity.this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, BlubberJellyEntity.this.func_226277_ct_(), BlubberJellyEntity.this.func_226278_cu_(), BlubberJellyEntity.this.func_226281_cx_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

